(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     44414,       1169]
NotebookOptionsPosition[     41633,       1085]
NotebookOutlinePosition[     41985,       1100]
CellTagsIndexPosition[     41942,       1097]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Triplet", "Title",
 CellChangeTimes->{{3.6778557350108614`*^9, 3.6778557364808636`*^9}}],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["Triplet",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["\[CapitalDelta]",
           FontWeight->Bold], Cell[
          "distance between the corrector and the mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["TripletInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Design of a Third-order Triplet", "Title",
 CellChangeTimes->{{3.677855760490897*^9, 3.677855782370928*^9}}],

Cell["\<\
We consider  a triplet of thin lenses in which the last two lenses are \
cemented . Then, to determine the radii of the five surfaces, we can impose \
the following 5 conditions:\
\>", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42505826603125*^9, 
   3.425058269859375*^9}, {3.42505830115625*^9, 3.425058406890625*^9}, {
   3.425058440515625*^9, 3.42505856753125*^9}, 3.426323961765625*^9, {
   3.426326613265625*^9, 3.4263266156875*^9}, {3.426401870046875*^9, 
   3.426401892265625*^9}, {3.4378176685625*^9, 3.437817674015625*^9}, 
   3.677855786220933*^9},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["focale length,", "Item",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42505826603125*^9, 
   3.425058269859375*^9}, {3.42505830115625*^9, 3.425058406890625*^9}, {
   3.425058440515625*^9, 3.42505856753125*^9}, 3.426323961765625*^9, {
   3.426326613265625*^9, 3.4263266156875*^9}, {3.426401870046875*^9, 
   3.426401892265625*^9}, {3.4378176685625*^9, 3.437817674015625*^9}, {
   3.6778557874209347`*^9, 3.6778558069409623`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["\<\
the back focals bfb and bfg, respectively corresponding to blue and \
green-light, coincide,\
\>", "Item",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42505826603125*^9, 
   3.425058269859375*^9}, {3.42505830115625*^9, 3.425058406890625*^9}, {
   3.425058440515625*^9, 3.42505856753125*^9}, 3.426323961765625*^9, {
   3.426326613265625*^9, 3.4263266156875*^9}, {3.426401870046875*^9, 
   3.426401892265625*^9}, {3.4378176685625*^9, 3.437817674015625*^9}, {
   3.677855788100936*^9, 3.6778558079409637`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["\<\
the back focals bfr and bfg, respectively corresponding to red and \
green-light, coincide,\
\>", "Item",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42505826603125*^9, 
   3.425058269859375*^9}, {3.42505830115625*^9, 3.425058406890625*^9}, {
   3.425058440515625*^9, 3.42505856753125*^9}, 3.426323961765625*^9, {
   3.426326613265625*^9, 3.4263266156875*^9}, {3.426401870046875*^9, 
   3.426401892265625*^9}, {3.4378176685625*^9, 3.437817674015625*^9}, {
   3.677855788100936*^9, 3.6778558105609674`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["the spherical aberration vanishes,", "Item",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42505826603125*^9, 
   3.425058269859375*^9}, {3.42505830115625*^9, 3.425058406890625*^9}, {
   3.425058440515625*^9, 3.42505856753125*^9}, 3.426323961765625*^9, {
   3.426326613265625*^9, 3.4263266156875*^9}, {3.426401870046875*^9, 
   3.426401892265625*^9}, {3.4378176685625*^9, 3.437817674015625*^9}, {
   3.677855788100936*^9, 3.6778558116109686`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["coma vanishes.", "Item",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42505826603125*^9, 
   3.425058269859375*^9}, {3.42505830115625*^9, 3.425058406890625*^9}, {
   3.425058440515625*^9, 3.42505856753125*^9}, 3.426323961765625*^9, {
   3.426326613265625*^9, 3.4263266156875*^9}, {3.426401870046875*^9, 
   3.426401892265625*^9}, {3.4378176685625*^9, 3.437817674015625*^9}, {
   3.677855788100936*^9, 3.6778558126509705`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["\<\
the variables N1, N2, N3, N1b, N2b, N3b, N1r, N2r, N3r, \[Lambda], \
\[Lambda]b, \[Lambda]r, c1, c2, c3, c4, c5, y1, \[Theta] have to be \
unassigned, for that we use Clear\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "N1", ",", "N2", ",", "N3", ",", "N1b", ",", "N2b", ",", "N3b", ",", "N1r",
     ",", "N2r", ",", "N3r", ",", "\[Lambda]", ",", "\[Lambda]b", ",", 
    "\[Lambda]r", ",", "c1", ",", "c2", ",", "c3", ",", "c4", ",", "c5", ",", 
    "y1", ",", "\[Theta]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "N1", ",", "1", ",", "N2", ",", "N3", ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N1b", ",", "1", ",", "N2b", ",", "N3b", ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N1r", ",", "1", ",", "N2r", ",", "N3r", ",", "1"}], 
      "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "\[Lambda]b", ",", "\[Lambda]r"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"TotalAberrations", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", " ", 
      RowBox[{"1", "/", "c2"}], ",", " ", 
      RowBox[{"1", "/", "c3"}], ",", " ", 
      RowBox[{"1", "/", "c4"}], ",", 
      RowBox[{"1", "/", "c5"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0"}], "}"}], ",", " ", 
    "ind", ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", " ", 
    "r", ",", " ", "0", ",", " ", "0", ",", " ", 
    RowBox[{"-", "Infinity"}], ",", " ", "y1", ",", "\[Theta]", ",", " ", 
    "waves"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"GOfocalLength", "[", 
        RowBox[{"[", "1", "]"}], "]"}]], "-", 
      FractionBox["1", "f"]}], "]"}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.415510112554552*^9, 3.415510257945177*^9}, {
  3.42496595096875*^9, 3.424965960265625*^9}, {3.42496601328125*^9, 
  3.4249660159375*^9}, {3.4250587048125*^9, 3.425058726640625*^9}, {
  3.6778558349210014`*^9, 3.6778558429410124`*^9}}],

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"GOdistancegauss", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "GOn"}], "]"}], "]"}]], "-", 
      FractionBox["1", 
       RowBox[{"GOdistancegauss", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "GOn"}], "]"}], "]"}]]}], "]"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.415510112554552*^9, 3.415510257945177*^9}, {
  3.42496595096875*^9, 3.424965960265625*^9}, {3.42496601328125*^9, 
  3.4249660159375*^9}, {3.4250587048125*^9, 3.425058726640625*^9}, {
  3.6778558349210014`*^9, 3.677855875521058*^9}}],

Cell[BoxData[
 RowBox[{"eq3", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"GOdistancegauss", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "GOn"}], "]"}], "]"}]], "-", 
      FractionBox["1", 
       RowBox[{"GOdistancegauss", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "GOn"}], "]"}], "]"}]]}], "]"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.415510112554552*^9, 3.415510257945177*^9}, {
  3.42496595096875*^9, 3.424965960265625*^9}, {3.42496601328125*^9, 
  3.4249660159375*^9}, {3.4250587048125*^9, 3.425058726640625*^9}, {
  3.6778558349210014`*^9, 3.677855875521058*^9}}],

Cell["By introducing the new variables", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.4250587428125*^9, 
   3.42505876690625*^9}, {3.425225633703125*^9, 3.425225638421875*^9}, 
   3.67785588370107*^9},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Xi]1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c1", "-", "c2"}], ")"}], "f"}]}], ",", "\[IndentingNewLine]", 
  RowBox[{"\[Xi]2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c3", "-", "c4"}], ")"}], "f"}]}], ",", "\[IndentingNewLine]", 
  RowBox[{"\[Xi]3", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c4", "-", "c5"}], ")"}], "f"}]}], ","}]], "DisplayFormula",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.4250587428125*^9, 
   3.42505876690625*^9}, {3.425225633703125*^9, 3.425225638421875*^9}, {
   3.6778558841810703`*^9, 3.677855901171094*^9}}],

Cell["the above equations become", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.4250587428125*^9, 
   3.42505876690625*^9}, {3.425225633703125*^9, 3.425225638421875*^9}, {
   3.6778558841810703`*^9, 3.6778558885510764`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{"eq11", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Xi]1", " ", 
     RowBox[{"(", 
      RowBox[{"N1", "-", "1"}], ")"}]}], "+", 
    RowBox[{"\[Xi]2", " ", 
     RowBox[{"(", " ", 
      RowBox[{"N2", "-", "1"}], ")"}]}], "+", 
    RowBox[{"\[Xi]3", 
     RowBox[{"(", 
      RowBox[{"N3", "-", "1"}], ")"}]}]}], "\[Equal]", "1"}]}]], "Input",
 CellChangeTimes->{{3.42496631534375*^9, 3.4249663171875*^9}, {
  3.424966401421875*^9, 3.424966438796875*^9}, {3.424966470953125*^9, 
  3.424966502390625*^9}, {3.42496656121875*^9, 3.424966626578125*^9}, {
  3.424967123125*^9, 3.424967145828125*^9}, {3.425059169515625*^9, 
  3.4250592006875*^9}, {3.4250592998125*^9, 3.425059359265625*^9}, {
  3.6778559067111015`*^9, 3.6778559079011035`*^9}}],

Cell[BoxData[
 RowBox[{"eq12", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Xi]1", 
     RowBox[{"(", 
      RowBox[{"N1b", "-", "N1"}], ")"}]}], "+", 
    RowBox[{"\[Xi]2", " ", 
     RowBox[{"(", 
      RowBox[{"N2b", "-", "N2"}], ")"}]}], "+", 
    RowBox[{"\[Xi]3", " ", 
     RowBox[{"(", 
      RowBox[{"N3b", "-", "N3"}], ")"}]}]}], "\[Equal]", "0"}]}]], "Input",
 CellChangeTimes->{{3.42496631534375*^9, 3.4249663171875*^9}, {
  3.424966401421875*^9, 3.424966438796875*^9}, {3.424966470953125*^9, 
  3.424966502390625*^9}, {3.42496656121875*^9, 3.424966626578125*^9}, {
  3.424967123125*^9, 3.424967145828125*^9}, {3.425059169515625*^9, 
  3.4250592006875*^9}, {3.4250592998125*^9, 3.425059359265625*^9}, {
  3.6778559067111015`*^9, 3.6778559102911067`*^9}}],

Cell[BoxData[
 RowBox[{"eq13", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Xi]1", 
     RowBox[{"(", 
      RowBox[{"N1r", "-", "N1"}], ")"}]}], "+", 
    RowBox[{"\[Xi]2", " ", 
     RowBox[{"(", 
      RowBox[{"N2r", "-", "N2"}], ")"}]}], "+", 
    RowBox[{"\[Xi]3", " ", 
     RowBox[{"(", 
      RowBox[{"N3r", "-", "N3"}], ")"}]}]}], "\[Equal]", "0"}]}]], "Input",
 CellChangeTimes->{{3.42496631534375*^9, 3.4249663171875*^9}, {
  3.424966401421875*^9, 3.424966438796875*^9}, {3.424966470953125*^9, 
  3.424966502390625*^9}, {3.42496656121875*^9, 3.424966626578125*^9}, {
  3.424967123125*^9, 3.424967145828125*^9}, {3.425059169515625*^9, 
  3.4250592006875*^9}, {3.4250592998125*^9, 3.425059359265625*^9}, {
  3.6778559067111015`*^9, 3.677855913341111*^9}}],

Cell["If we put", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.4250587428125*^9, 
   3.42505876690625*^9}, {3.425142194609375*^9, 3.425142280828125*^9}, 
   3.6778559173111167`*^9},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]i", " ", "=", 
   RowBox[{"Ni", "-", "1"}]}], ",", "\n", 
  RowBox[{"\[Beta]i", "=", " ", 
   RowBox[{"Nib", "-", "Ni"}]}], ",", "\n", 
  RowBox[{"\[Gamma]i", "=", " ", 
   RowBox[{"Nir", "-", "Ni"}]}], ","}]], "DisplayFormula",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.4250587428125*^9, 
   3.42505876690625*^9}, {3.425142194609375*^9, 3.425142280828125*^9}, {
   3.677855917601117*^9, 3.677855939141147*^9}}],

Cell["we have", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.4250587428125*^9, 
   3.42505876690625*^9}, {3.425142194609375*^9, 3.425142280828125*^9}, {
   3.677855917601117*^9, 3.6778559265211296`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{"eq11", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Alpha]", "1"], "\[Xi]1"}], " ", "+", 
    RowBox[{
     SubscriptBox["\[Alpha]", "2"], "\[Xi]2"}], " ", "+", 
    RowBox[{
     SubscriptBox["\[Alpha]", "3"], "\[Xi]3"}]}], "\[Equal]", 
   "1"}]}]], "Input",
 CellChangeTimes->{{3.42496631534375*^9, 3.4249663171875*^9}, {
   3.424966401421875*^9, 3.424966438796875*^9}, {3.424966470953125*^9, 
   3.424966502390625*^9}, {3.42496656121875*^9, 3.424966626578125*^9}, {
   3.424967123125*^9, 3.424967145828125*^9}, {3.425059169515625*^9, 
   3.4250592006875*^9}, {3.4250592998125*^9, 3.425059359265625*^9}, {
   3.425142300109375*^9, 3.42514241671875*^9}, 3.677855950591163*^9}],

Cell[BoxData[
 RowBox[{"eq12", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Beta]", "1"], "\[Xi]1"}], "+", 
    RowBox[{
     SubscriptBox["\[Beta]", "2"], "\[Xi]2"}], " ", "+", 
    RowBox[{
     SubscriptBox["\[Beta]", "3"], "\[Xi]3"}]}], " ", "\[Equal]", 
   "0"}]}]], "Input",
 CellChangeTimes->{{3.42496631534375*^9, 3.4249663171875*^9}, {
  3.424966401421875*^9, 3.424966438796875*^9}, {3.424966470953125*^9, 
  3.424966502390625*^9}, {3.42496656121875*^9, 3.424966626578125*^9}, {
  3.424967123125*^9, 3.424967145828125*^9}, {3.425059169515625*^9, 
  3.4250592006875*^9}, {3.4250592998125*^9, 3.425059359265625*^9}, {
  3.425142300109375*^9, 3.42514241671875*^9}, {3.677855950591163*^9, 
  3.677855953161167*^9}}],

Cell[BoxData[
 RowBox[{"eq13", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], "\[Xi]1"}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "2"], "\[Xi]2"}], " ", "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "3"], "\[Xi]3"}]}], " ", "\[Equal]", 
   "0"}]}]], "Input",
 CellChangeTimes->{{3.42496631534375*^9, 3.4249663171875*^9}, {
  3.424966401421875*^9, 3.424966438796875*^9}, {3.424966470953125*^9, 
  3.424966502390625*^9}, {3.42496656121875*^9, 3.424966626578125*^9}, {
  3.424967123125*^9, 3.424967145828125*^9}, {3.425059169515625*^9, 
  3.4250592006875*^9}, {3.4250592998125*^9, 3.425059359265625*^9}, {
  3.425142300109375*^9, 3.42514241671875*^9}, {3.677855950591163*^9, 
  3.67785595535117*^9}}],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq11", ",", "eq12", ",", "eq13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Xi]1", ",", "\[Xi]2", ",", "\[Xi]3"}], "}"}]}], "]"}], 
    "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.415510266288927*^9, 3.415510290570177*^9}, {
  3.42496596815625*^9, 3.4249659711875*^9}, {3.424966638390625*^9, 
  3.4249666618125*^9}, {3.425009326734375*^9, 3.42500933459375*^9}, {
  3.4250094385*^9, 3.4250094454375*^9}, {3.42505936359375*^9, 
  3.425059371484375*^9}}],

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Beta]", "1"], ",", 
     SubscriptBox["\[Beta]", "2"], ",", 
     SubscriptBox["\[Beta]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], ",", 
     SubscriptBox["\[Gamma]", "2"], ",", 
     SubscriptBox["\[Gamma]", "3"]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.425226437015625*^9, 3.42522652778125*^9}, {
   3.6778581569275403`*^9, 3.6778581572375407`*^9}, 3.67785819238871*^9}],

Cell["Finally, we have", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.425009376765625*^9, 
   3.425009380515625*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{"sost", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c1", "\[Rule]", 
     RowBox[{"c2", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]1", ",", "s1"}], "]"}]}]}], ",", 
    RowBox[{"c3", "\[Rule]", 
     RowBox[{"c4", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]2", ",", "s1"}], "]"}]}]}], ",", 
    RowBox[{"c4", "\[Rule]", 
     RowBox[{"c5", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]3", ",", "s1"}], "]"}]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4250093855*^9, 3.42500947103125*^9}, 
   3.42500959284375*^9, {3.4250593961875*^9, 3.425059453578125*^9}, {
   3.425142499109375*^9, 3.425142536328125*^9}, {3.425209491703125*^9, 
   3.425209532703125*^9}, 3.4252096189375*^9, 3.677858201720724*^9, {
   3.6778584121670384`*^9, 3.6778584382860775`*^9}}],

Cell[BoxData[
 RowBox[{"sost1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c1", "\[Rule]", 
     RowBox[{"c2", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]1", ",", "s1"}], "]"}]}]}], ",", 
    RowBox[{"c3", "\[Rule]", 
     RowBox[{"c5", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]3", ",", "s1"}], "]"}], "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]2", ",", "s1"}], "]"}]}]}], ",", 
    RowBox[{"c4", "\[Rule]", 
     RowBox[{"c5", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]3", ",", "s1"}], "]"}]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4250093855*^9, 3.42500947103125*^9}, 
   3.42500959284375*^9, {3.4250593961875*^9, 3.425059453578125*^9}, {
   3.425142499109375*^9, 3.425142536328125*^9}, {3.425209491703125*^9, 
   3.425209532703125*^9}, 3.4252096189375*^9, {3.677858201720724*^9, 
   3.6778582048707285`*^9}, {3.6778584475560904`*^9, 3.6778584685911217`*^9}}],

Cell[BoxData[
 RowBox[{"sost2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c1", "\[Rule]", 
     RowBox[{"c2", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]1", ",", "s1"}], "]"}]}]}], ",", 
    RowBox[{"c3", "\[Rule]", 
     RowBox[{"c4", "+", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]2", ",", "s1"}], "]"}]}]}], ",", 
    RowBox[{"c5", "\[Rule]", 
     RowBox[{"c4", "-", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{"\[Xi]3", ",", "s1"}], "]"}]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4250093855*^9, 3.42500947103125*^9}, 
   3.42500959284375*^9, {3.4250593961875*^9, 3.425059453578125*^9}, {
   3.425142499109375*^9, 3.425142536328125*^9}, {3.425209491703125*^9, 
   3.425209532703125*^9}, 3.4252096189375*^9, {3.677858201720724*^9, 
   3.677858207600733*^9}, {3.6778584815251403`*^9, 3.677858491820156*^9}}],

Cell["Coma vanishes if", "Text",
 CellChangeTimes->{{3.415509791023302*^9, 3.415509809867052*^9}, {
   3.415509854226427*^9, 3.415509947132677*^9}, 3.424965866171875*^9, {
   3.42496614171875*^9, 3.424966174296875*^9}, {3.42496624528125*^9, 
   3.424966296921875*^9}, {3.42496635971875*^9, 3.424966370671875*^9}, {
   3.424967110609375*^9, 3.424967118484375*^9}, {3.425009376765625*^9, 
   3.425009380515625*^9}, {3.4250095181875*^9, 3.42500952328125*^9}},
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{"eqco", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Together", "[", 
     RowBox[{"GOComaCoefficient", "/.", "sost1"}], "]"}], "//", "Numerator"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.4250095379375*^9, 3.4250095494375*^9}, 
   3.4250096015625*^9, 3.4251425295625*^9, {3.6778582191207485`*^9, 
   3.6778582266307592`*^9}}],

Cell[BoxData[
 RowBox[{"eqco2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Together", "[", 
     RowBox[{"GOComaCoefficient", "/.", "sost2"}], "]"}], "//", "Numerator"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.42520954934375*^9, 3.425209553125*^9}, 
   3.677858248833792*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Coefficient", "[", 
   RowBox[{"eqco2", ",", 
    RowBox[{"c4", "^", "2"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.425208880609375*^9, 3.425208950765625*^9}, {
   3.42520958875*^9, 3.425209600125*^9}, 3.4252096448125*^9}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"GOSphericalCoefficient", "/.", "sost"}], "]"}], "//", 
   "Numerator"}], "]"}]], "Input",
 CellChangeTimes->{{3.415510308351427*^9, 3.415510339023302*^9}, {
   3.415510372851427*^9, 3.415510404710802*^9}, {3.425009476484375*^9, 
   3.425009490875*^9}, 3.425009628890625*^9, {3.677858270041823*^9, 
   3.6778582714318247`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triplet Examples", "Title",
 CellChangeTimes->{{3.402902062703125*^9, 3.4029020860625*^9}, {
   3.402903223921875*^9, 3.4029032253125*^9}, {3.425058817859375*^9, 
   3.425058820328125*^9}, 3.43892875853125*^9, {3.6778672982695684`*^9, 
   3.6778673012795725`*^9}}],

Cell["\<\
To use the Triplet function you can either use directly the function \
Triplet[thick, ind, diam, \[Theta], waves, focal] or use the interactive \
panel created by calling the function TripletInputPanel[]. It let\
\[CloseCurlyQuote]s you to set input values and then call the Triplet \
function. Moreover, it helps to load examples from the saved archives and set \
the output style.
Here are some examples\
\>", "Text"],

Cell["Triplet F/10 BK7-KZFS1-BaF4", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Tripletto", ":", "Atmos"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"thick", "=", 
     RowBox[{"{", 
      RowBox[{"12", ",", "0", ",", "8", ",", "12"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ind", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1.51872218", ",", "1", ",", "1.61638648", ",", 
         "1.60889483", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1.52237649", ",", "1", ",", "1.62275976", ",", 
         "1.61531614", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1.51432242", ",", "1", ",", "1.60893217", ",", 
         "1.60152968", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"diam", "=", "100"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "0.6"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"waves", "=", 
     RowBox[{"{", 
      RowBox[{"0.54607", ",", "0.48613", ",", "0.65627"}], "}"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"focal", "=", "1000"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.4251758349375*^9, 3.425189706125*^9, {3.42518986203125*^9, 
   3.42518987965625*^9}, 3.426399269875*^9, {3.42639973440625*^9, 
   3.426399738640625*^9}, {3.4263998606875*^9, 3.426399865140625*^9}, 
   3.42640031834375*^9, {3.4264005105*^9, 3.426400520578125*^9}, {
   3.426410264015625*^9, 3.426410292890625*^9}, 3.4264106394375*^9, 
   3.6778660128257685`*^9, 3.6782810178366413`*^9}],

Cell[BoxData[
 RowBox[{"Triplet", "[", 
  RowBox[{
  "thick", ",", "ind", ",", "diam", ",", "\[Theta]", ",", "waves", ",", 
   "focal"}], "]"}]], "Input",
 CellChangeTimes->{
  3.4251758349375*^9, 3.425189706125*^9, {3.42518986203125*^9, 
   3.42518987965625*^9}, 3.426399269875*^9, {3.42639973440625*^9, 
   3.426399738640625*^9}, {3.4263998606875*^9, 3.426399865140625*^9}, 
   3.42640031834375*^9, {3.4264005105*^9, 3.426400520578125*^9}, {
   3.426410264015625*^9, 3.426410292890625*^9}, 3.4264106394375*^9, 
   3.6778660128257685`*^9, 3.6778670320031953`*^9, 3.678281019497736*^9}],

Cell["Triplet F/10 BK7-KZFS1-BaFN10", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "0", ",", "9", ",", "15"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1.51872218", ",", "1", ",", "1.61638648", ",", "1.6734127", 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1.51432242", ",", "1", ",", "1.60893217", ",", "1.6657859", 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1.52237649", ",", "1", ",", "1.62275976", ",", "1.6800089", 
       ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"0.54607", ",", "0.65627", ",", "0.48613"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"focal", "=", "1000"}], ";"}]}], "Input",
 CellChangeTimes->{{3.425189690984375*^9, 3.425189698328125*^9}, {
   3.425189733*^9, 3.42518973346875*^9}, {3.426400630109375*^9, 
   3.42640065365625*^9}, 3.6778672895095563`*^9, {3.6782809889619894`*^9, 
   3.6782810027917805`*^9}}],

Cell[BoxData[
 RowBox[{"Triplet", "[", 
  RowBox[{
  "thick", ",", "ind", ",", "diam", ",", "\[Theta]", ",", "waves", ",", 
   "focal"}], "]"}]], "Input",
 CellChangeTimes->{{3.425189690984375*^9, 3.425189698328125*^9}, {
   3.425189733*^9, 3.42518973346875*^9}, {3.426400630109375*^9, 
   3.42640065365625*^9}, 3.6778672895095563`*^9, {3.6782809889619894`*^9, 
   3.678281006201976*^9}}],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<Triplet\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Triplet", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"TripletInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-10, Automatic}, {Automatic, 10}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 94, 1, 71, "Title"],
Cell[CellGroupData[{
Cell[698, 27, 35, 0, 43, "Subsection"],
Cell[736, 29, 102, 2, 46, "Text"],
Cell[841, 33, 1716, 45, 345, "Text"],
Cell[2560, 80, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4707, 138, 40, 0, 43, "Subsection"],
Cell[4750, 140, 243, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5030, 151, 40, 0, 43, "Subsection"],
Cell[5073, 153, 111, 2, 46, "Text"],
Cell[5187, 157, 3193, 83, 551, "Text"],
Cell[8383, 242, 2296, 56, 473, "Text"],
Cell[10682, 300, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14196, 395, 114, 1, 71, "Title"],
Cell[14313, 398, 769, 14, 45, "Text"],
Cell[15085, 414, 625, 10, 25, "Item"],
Cell[15713, 426, 709, 13, 25, "Item"],
Cell[16425, 441, 708, 13, 25, "Item"],
Cell[17136, 456, 643, 10, 25, "Item"],
Cell[17782, 468, 623, 10, 25, "Item"],
Cell[18408, 480, 196, 4, 46, "Text"],
Cell[18607, 486, 1616, 43, 99, "Input"],
Cell[20226, 531, 563, 13, 52, "Input"],
Cell[20792, 546, 707, 18, 52, "Input"],
Cell[21502, 566, 707, 18, 52, "Input"],
Cell[22212, 586, 544, 9, 45, "Text"],
Cell[22759, 597, 895, 20, 70, "DisplayFormula"],
Cell[23657, 619, 567, 9, 45, "Text"],
Cell[24227, 630, 764, 18, 32, "Input"],
Cell[24994, 650, 765, 18, 32, "Input"],
Cell[25762, 670, 763, 18, 32, "Input"],
Cell[26528, 690, 524, 9, 45, "Text"],
Cell[27055, 701, 745, 14, 70, "DisplayFormula"],
Cell[27803, 717, 546, 9, 45, "Text"],
Cell[28352, 728, 719, 16, 32, "Input"],
Cell[29074, 746, 738, 17, 32, "Input"],
Cell[29815, 765, 740, 17, 32, "Input"],
Cell[30558, 784, 629, 15, 32, "Input"],
Cell[31190, 801, 528, 14, 32, "Input"],
Cell[31721, 817, 460, 8, 45, "Text"],
Cell[32184, 827, 836, 20, 32, "Input"],
Cell[33023, 849, 948, 22, 32, "Input"],
Cell[33974, 873, 859, 20, 32, "Input"],
Cell[34836, 895, 503, 8, 45, "Text"],
Cell[35342, 905, 368, 9, 32, "Input"],
Cell[35713, 916, 297, 8, 32, "Input"],
Cell[36013, 926, 278, 6, 32, "Input"],
Cell[36294, 934, 420, 9, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36751, 948, 270, 4, 71, "Title"],
Cell[37024, 954, 429, 8, 94, "Text"],
Cell[37456, 964, 43, 0, 46, "Text"],
Cell[37502, 966, 1536, 42, 165, "Input"],
Cell[39041, 1010, 586, 11, 32, "Input"],
Cell[39630, 1023, 45, 0, 46, "Text"],
Cell[39678, 1025, 1200, 34, 143, "Input"],
Cell[40881, 1061, 388, 8, 32, "Input"],
Cell[41272, 1071, 65, 0, 46, "Text"],
Cell[41340, 1073, 78, 1, 32, "Input"],
Cell[41421, 1076, 55, 1, 32, "Input"],
Cell[41479, 1079, 70, 0, 46, "Text"],
Cell[41552, 1081, 65, 1, 32, "Input"]
}, Open  ]]
}
]
*)

